// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "container.h"

//Writing buffer for use in EXI devices
class WriteBuffer {
public:
	WriteBuffer(size_t s) : _buffer(s), _size(0) {}

	size_t size() const { return _size; }
	size_t capacity() const { return _buffer.size(); }
	void write(size_t s, const void *src) {
		if(_size + s >= _buffer.size())
			throw hardware_fatal_exception("Write too large!");

		memcpy(_buffer + _size, src, s);
		_size += s;
	}
	void clear() {
		_size = 0;
	}
	BYTE*const p() { return _buffer; }
private:
	Container<BYTE> _buffer;
	size_t _size;
};
